﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Practices.Prism.Commands;
using Microsoft.Practices.Prism.Regions;
using Microsoft.Practices.ServiceLocation;
using Services;
using ModuleA.Views;
using ModuleA.ViewModels;
using Microsoft.Practices.Prism.Mvvm;
using System.Windows.Input;
using System.Windows;

namespace ModuleA
{
	class ButtonViewAViewModel
	{
		private readonly IRegionManager regionManager;
		private readonly IAuthority authority;
		public CompositeCommand SwitchViewCommand { get; set; }

		public ButtonViewAViewModel()
		{
			regionManager = ServiceLocator.Current.GetInstance<IRegionManager>();
			authority = ServiceLocator.Current.GetInstance<IAuthority>();
            //SwitchViewCommand = new CompositeCommand();
			GlobalCommands.SwitchViewCommand.RegisterCommand( new DelegateCommand(SwitchView));
		}

		private void SwitchView()
		{
			if (authority.IsEditor)
				regionManager.RequestNavigate("MainRegion", new Uri("EditorCatalog", UriKind.Relative));
			else
				regionManager.RequestNavigate("MainRegion", new Uri("Catalog", UriKind.Relative));
		}
	}
}
